<?php
/**
 * Class MtboricaGetRecurringModuleFrontController
 *
 * Returns recurring plan data as JSON for a given id. Intended for
 * populating the edit modal in the module's admin UI. Enforces
 * back-office admin authentication.
 */
class MtboricaGetRecurringModuleFrontController extends ModuleFrontController
{
    public $result = array();

    /**
     * Initializes controller and enforces admin authentication.
     *
     * @return void
     */
    public function init()
    {
        parent::init();

        $cookie = new Cookie('psAdmin');
        if (!$cookie->id_employee || !$cookie->isLoggedBack()) {
            die(json_encode(array(
                'success' => false,
                'message' => 'You must be logged in as administrator'
            )));
        }
    }

    /**
     * Handles the data retrieval for a single recurring plan.
     *
     * Input: GET `id` (int)
     * Output: JSON with `success` and `data` fields or error message
     *
     * @return void
     */
    public function initContent()
    {
        parent::initContent();

        $id = (int) Tools::getValue('id');
        if ($id <= 0) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Invalid ID parameter.')
            );
            return;
        }

        require_once _PS_MODULE_DIR_ . 'mtborica/classes/MtboricaRecurring.php';

        $recurring = new MtboricaRecurring($id);
        if (!Validate::isLoadedObject($recurring)) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Recurring plan not found.')
            );
            return;
        }

        $this->result = array(
            'success' => true,
            'data' => array(
                'id' => (int) $recurring->id,
                'name' => (string) $recurring->name,
                'status' => (int) $recurring->status,
                'recur_duration' => (string) $recurring->recur_duration,
                'recur_duration_unit' => (string) $recurring->recur_duration_unit,
                'recur_freq' => (string) $recurring->recur_freq,
                'recur_freq_unit' => (string) $recurring->recur_freq_unit,
                'recur_mday_payment' => (string) $recurring->recur_mday_payment,
            )
        );
    }

    /**
     * Outputs the JSON response.
     *
     * @return void
     */
    public function displayAjax()
    {
        header('Content-Type: application/json');
        die(Tools::jsonEncode($this->result));
    }
}


