<?php
require_once _PS_MODULE_DIR_ . 'mtborica/mtborica.php';

/**
 * Class MtboricaSaveCartPlanModuleFrontController
 *
 * AJAX controller for saving recurring plan ID to database when product is added to cart.
 * Called by JavaScript after successful add to cart.
 */
class MtboricaSaveCartPlanModuleFrontController extends ModuleFrontController
{
    /**
     * Aggregated JSON payload to be returned by displayAjax().
     *
     * @var array|null
     */
    public $result = null;

    /**
     * Initializes controller content for AJAX flow.
     *
     * @return void
     */
    public function initContent()
    {
        parent::initContent();
        $this->ajax = true;

        // Check if recurring feature is enabled
        if (!Mtborica::isRecurringEnabled()) {
            $this->result = [
                'success' => false,
                'message' => 'Recurring feature is disabled',
            ];
            return;
        }

        $this->result = [];

        if (isset($_SERVER['REQUEST_METHOD']) && 'POST' === $_SERVER['REQUEST_METHOD']) {
            // Get parameters
            $cart_id = (int) Tools::getValue('cart_id', 0);
            $product_id = (int) Tools::getValue('product_id', 0);
            $product_attribute_id = (int) Tools::getValue('id_product_attribute', 0);
            $recurring_plan_id = (int) Tools::getValue('recurring_plan_id', 0);

            // If no cart_id provided, use current cart
            if ($cart_id <= 0) {
                $cart_id = (int) ($this->context->cart->id ?? 0);
            }

            if ($cart_id <= 0 || $product_id <= 0) {
                $this->result = [
                    'success' => false,
                    'message' => 'Invalid cart or product ID',
                ];
                return;
            }

            // Clean up any orphaned records before saving the new plan selection
            Mtborica::cleanupOrphanedCartPlans($cart_id);

            // Save plan ID to database
            $saved = Mtborica::saveCartProductRecurringPlan(
                $cart_id,
                $product_id,
                $product_attribute_id,
                $recurring_plan_id
            );

            if ($saved) {
                $this->result = [
                    'success' => true,
                    'message' => 'Plan saved successfully',
                ];
            } else {
                $this->result = [
                    'success' => false,
                    'message' => 'Failed to save plan',
                ];
            }
        } else {
            $this->result = [
                'success' => false,
                'message' => 'Invalid request method',
            ];
        }
    }

    /**
     * Outputs the aggregated JSON response and terminates execution.
     *
     * @return void
     */
    public function displayAjax()
    {
        header('Content-Type: application/json');
        die(Tools::jsonEncode($this->result));
    }
}
