<?php
/**
 * Class MtboricaToggleRecurringStatusModuleFrontController
 *
 * Toggles the active status of a recurring plan. Ensures admin
 * authentication and responds with JSON for the admin UI.
 */

class MtboricaToggleRecurringStatusModuleFrontController extends ModuleFrontController
{
    public $result = array();

    /**
     * Initializes controller and enforces admin authentication.
     *
     * @return void
     */
    public function init()
    {
        parent::init();

        // Check if user is logged in as admin
        $cookie = new Cookie('psAdmin');
        if (!$cookie->id_employee || !$cookie->isLoggedBack()) {
            die(json_encode(array(
                'success' => false,
                'message' => 'You must be logged in as administrator'
            )));
        }
    }

    /**
     * Processes the toggle status request.
     *
     * Input: POST `id` (int)
     * Output: JSON `success` and message
     *
     * @return void
     */
    public function initContent()
    {
        parent::initContent();

        if (!Tools::isSubmit('id')) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Missing ID parameter.')
            );
            return;
        }

        $id = (int) Tools::getValue('id');
        if ($id <= 0) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Invalid ID parameter.')
            );
            return;
        }

        try {
            require_once _PS_MODULE_DIR_ . 'mtborica/classes/MtboricaRecurring.php';

            $result = MtboricaRecurring::toggleRecurringStatus($id);

            if ($result) {
                $this->result = array(
                    'success' => true,
                    'message' => $this->l('Status updated successfully.')
                );
            } else {
                $this->result = array(
                    'success' => false,
                    'message' => $this->l('Failed to update status.')
                );
            }
        } catch (Exception $e) {
            $this->result = array(
                'success' => false,
                'message' => $this->l('Error: ') . $e->getMessage()
            );
        }
    }

    /**
     * Outputs the JSON response.
     *
     * @return void
     */
    public function displayAjax()
    {
        header('Content-Type: application/json');
        die(Tools::jsonEncode($this->result));
    }
}
