<div
    role="tabpanel"
    class="tab-pane"
    id="mtborica_tab_content"
>
    <div class="row">
        <div class="col-md-6">
            <div
                class="panel"
                style="border: 1px solid #ddd; border-radius: 4px;"
            >
                <div
                    class="panel-heading"
                    style="background-color: #f5f5f5; padding: 15px;"
                >
                    {if $payment_data.recur_id == false}
                        {l s='Information on payment of the order by Credit/Debit card through Borika' mod='mtborica'}
                    {else}
                        {l s='Information on recurring payment of the order by Credit/Debit card through Borika' mod='mtborica'}
                    {/if}
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>{l s='Order ID :' mod='mtborica'}</td>
                                    <td>{$payment_data.increment_id|escape:'html':'UTF-8'}</td>
                                </tr>
                                <tr>
                                    <td>{l s='Total amount of the order :' mod='mtborica'}</td>
                                    <td>{$borica_order_total|number_format:2:'.':','|escape:'html':'UTF-8'}
                                        {$currency_sign|escape:'html':'UTF-8'}
                                    </td>
                                </tr>
                                <tr>
                                    <td>{if !$payment_data.recur_id}{l s='Date of transaction :' mod='mtborica'}{else}{l s='First payment date :' mod='mtborica'}{/if}
                                    </td>
                                    <td>{$payment_data.created_at|date_format:'%d.%m.%Y %H:%M:%S'|escape:'html':'UTF-8'}
                                    </td>
                                </tr>
                                {if $payment_data.recur_id}
                                    <tr>
                                        <td>{l s='Recurring payment plan :' mod='mtborica'}</td>
                                        <td>{$borica_reccuring_name|escape:'html':'UTF-8'}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>{l s='The plan reference (MERCH_RN_ID) :' mod='mtborica'}</td>
                                        <td>{$payment_data.merch_rn_id|escape:'html':'UTF-8'}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>{l s='Initial payment :' mod='mtborica'}</td>
                                        <td>{$payment_data.amount|number_format:2:'.':','|escape:'html':'UTF-8'}
                                            {$currency_sign|escape:'html':'UTF-8'}
                                        </td>
                                    </tr>
                                    {if $recurreng_paln_cancelled}
                                        <tr>
                                            <td>{l s='Plan status:' mod='mtborica'}</td>
                                            <td>{l s='Closed by the customer' mod='mtborica'}
                                            </td>
                                        </tr>
                                    {/if}
                                {/if}
                                <tr>
                                    <td>{l s='Action :' mod='mtborica'}
                                    </td>
                                    <td>
                                        <span class="{$borica_order_action_class|escape:'html':'UTF-8'}">
                                            <div id="boricaOrderAction">
                                                {$borica_order_action_text|escape:'html':'UTF-8'}
                                            </div>
                                        </span>
                                    </td>
                                </tr>
                                {if isset($order_status) && $order_status}
                                    <tr>
                                        <td>{l s='Plan status :' mod='mtborica'}
                                        </td>
                                        <td>
                                            <div style="color: red;">
                                                {l s='Closed by the customer' mod='mtborica'|escape:'html':'UTF-8'}</div>
                                        </td>
                                    </tr>
                                {/if}
                                <tr>
                                    <td>{l s='Return code :' mod='mtborica'}
                                    </td>
                                    <td>
                                        <div id="boricaRc">{$payment_data.rc|escape:'html':'UTF-8'}</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>{l s='Status :' mod='mtborica'}
                                    </td>
                                    <td>
                                        <div id="boricaStatus">{$payment_data.status|escape:'html':'UTF-8'}</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>{l s='Authorization code :' mod='mtborica'}
                                    </td>
                                    <td>
                                        {$payment_data.approval|escape:'html':'UTF-8'}
                                    </td>
                                </tr>
                                <tr>
                                    <td>{l s='Internal number (ORDER) :' mod='mtborica'}
                                    </td>
                                    <td>
                                        {$borica_order_internal|escape:'html':'UTF-8'}
                                    </td>
                                </tr>
                                <tr>
                                    <td>{l s='Reference (RRN) :' mod='mtborica'}
                                    </td>
                                    <td>
                                        {$payment_data.rrn|escape:'html':'UTF-8'}
                                    </td>
                                </tr>
                                <tr>
                                    <td>{l s='Internal reference :' mod='mtborica'}
                                    </td>
                                    <td>
                                        {$payment_data.int_ref|escape:'html':'UTF-8'}
                                    </td>
                                </tr>
                                <tr>
                                    <td>{l s='Cancellation of payment :' mod='mtborica'}
                                    </td>
                                    <td>
                                        <span class="{$borica_request_cancel_class|escape:'html':'UTF-8'}">
                                            <div id="boricaRequestCancel">
                                                {$borica_request_cancel_text|escape:'html':'UTF-8'}</div>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>


                    <div
                        class="panel-footer"
                        style="background-color: #f5f5f5; padding: 15px; display: flex; justify-content: center; align-items: center; border-top: 1px solid #ddd;"
                    >
                        <button
                            type="button"
                            class="btn btn-primary"
                            id="borica_btn_check_payment"
                        >
                            <i class="material-icons">autorenew</i> {l s='Check for transaction status' mod='mtborica'}
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div
                class="panel"
                style="border: 1px solid #ddd; border-radius: 4px;"
            >
                <div
                    class="panel-heading"
                    style="background-color: #f5f5f5; padding: 15px; border-bottom: 1px solid #ddd;"
                >
                    {l s='Payment Cancellation Request' mod='mtborica'}
                </div>
                <div
                    class="panel-body"
                    style="padding: 15px 15px 0 15px;"
                >
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>{l s='Amount of the Reversal Payment request' mod='mtborica'}</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-group">
                                <input
                                    type="number"
                                    value="{$payment_data.amount|escape:'html':'UTF-8'}"
                                    class="form-control"
                                    step="0.01"
                                    min="0"
                                    autocomplete="off"
                                    id="current_amount"
                                />
                                <small class="text-muted">
                                    {l s='You can enter an amount less than or equal to the total amount of the order. You can use the button to the right of the input field to load directly the total amount of the order.' mod='mtborica'}
                                </small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <button
                                    type="button"
                                    class="btn btn-outline-secondary"
                                    id="borica_btn_default_amount"
                                >
                                    {l s='Load the full amount' mod='mtborica'}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div
                    class="panel-footer"
                    style="background-color: #f5f5f5; padding: 15px; display: flex; justify-content: center; align-items: center; border-top: 1px solid #ddd;"
                >
                    <button
                        type="button"
                        id="borica_btn_cancell_payment"
                        class="btn btn-primary"
                    >
                        {l s='Refund' mod='mtborica'}
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- SweetAlert2 CSS -->
<link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css"
>

<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function() {
        var isBcps = parseInt('{$is_bcps|escape:'javascript':'UTF-8'}');
        var isBdp = parseInt('{$is_bdp|escape:'javascript':'UTF-8'}');

        if (isBcps === 0) {
            $('#borica_btn_check_payment').prop('disabled', true);
        }

        if (isBdp === 0) {
            $('#borica_btn_cancell_payment').prop('disabled', true);
        }

        $('#borica_btn_check_payment').on('click', function() {
            performBoricaCheckPayment();
        });

        $('#borica_btn_default_amount').on('click', function(event) {
            event.preventDefault();
            $('#current_amount').val('{$payment_data.amount|escape:'html':'UTF-8'}');
        });

        $('#borica_btn_cancell_payment').on('click', function() {
                var cancelAmount = parseFloat($('#current_amount').val());

                if (isNaN(cancelAmount) || cancelAmount <= 0 || cancelAmount > {$payment_data.amount|escape:'javascript':'UTF-8'}) {
                showBoricaModal('error', '{l s='Error' mod='mtborica'|escape:'javascript'}', '{l s='Please enter a valid amount to cancel.' mod='mtborica'|escape:'javascript'}', false);
                return;
            }

            performBoricaCancelPayment(cancelAmount);
        });

    function performBoricaCheckPayment() {
        // Disable buttons and show loading state
        var $checkBtn = $('#borica_btn_check_payment');
        var checkBtnOriginalHtml = $checkBtn.html();

        $checkBtn.prop('disabled', true).css('opacity', '0.6').html('<i class="material-icons" style="vertical-align: middle; animation: spin 1s linear infinite;">autorenew</i> {l s='Processing...' mod='mtborica'|escape:'javascript'}');

        // Build data object with all possible parameters
        // Controller will use only what it needs based on action
        let data = {
            action_type: 'checkPayment',
            ajax: 1,
            token: '{$token|escape:'javascript':'UTF-8'}',
            BORICA_URL: '{$borica_url|escape:'javascript':'UTF-8'}',
            TERMINAL: '{$borica_terminal|escape:'javascript':'UTF-8'}',
            TRTYPE: '{$borica_check_payment_trtype|escape:'javascript':'UTF-8'}',
            ORDER: '{$borica_order|escape:'javascript':'UTF-8'}',
            TRAN_TRTYPE: '{$borica_tran_trtype|escape:'javascript':'UTF-8'}',
            NONCE: '{$payment_data.nonce|escape:'javascript':'UTF-8'}',
            BORICA_CURRENCY_CODE: '{$borica_currency|escape:'javascript':'UTF-8'}',
            ACTION: '{$payment_data.action|escape:'javascript':'UTF-8'}',
            RC: '{$payment_data.rc|escape:'javascript':'UTF-8'}',
            STATUSMSG: '{$payment_data.status|escape:'javascript':'UTF-8'}',
        };

        $.ajax({
            url: '{$admin_url|escape:'javascript':'UTF-8'}',
            type: 'POST',
            data: data,
            dataType: 'json',
            success: function(response) {
                // Re-enable buttons
                $checkBtn.prop('disabled', false).css('opacity', '1').html(checkBtnOriginalHtml);

                if (response.resultChange) {
                    Swal.fire({
                        title: response.resultChangeTitle,
                        text: response.resultChangeText,
                        icon: 'success',
                        confirmButtonColor: '#1E91CF',
                        confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
                        allowOutsideClick: false
                    }).then((result) => {
                        if (response.responseRc) {
                            $('#boricaRc').text(response.responseRc);
                        }
                        if (response.responseStatus) {
                            $('#boricaStatus').text(response.responseStatus);
                        }
                        if (response.responseActionTxt) {
                            const boricaAllowedTag =
                                /<span[^>]*style="[^"]*"[^>]*>(.*?)<\/span>/i;
                            const boricaResponseText = response.responseActionTxt.match(
                                boricaAllowedTag);
                            if (boricaResponseText !== null) {
                                $('#boricaOrderAction').html(response.responseActionTxt);
                            } else {
                                $('#boricaOrderAction').text(response.responseActionTxt);
                            }
                        }
                    });
                } else {
                    Swal.fire({
                        title: response.resultChangeTitle,
                        text: response.resultChangeText,
                        icon: 'error',
                        confirmButtonColor: '#1E91CF',
                        confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
                        allowOutsideClick: false
                    });
                }
            },
            error: function() {
                // Re-enable buttons
                $checkBtn.prop('disabled', false).css('opacity', '1').html(checkBtnOriginalHtml);

                Swal.fire({
                    title: '{l s='Error' mod='mtborica'|escape:'javascript'}',
                    text: '{l s='An error occurred while processing the request.' mod='mtborica'|escape:'javascript'}',
                    icon: 'error',
                    confirmButtonColor: '#1E91CF',
                    confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
                    allowOutsideClick: false
                });
            }
        });
    }

    function performBoricaCancelPayment(cancelAmount) {
        Swal.fire({
            title: '{l s='Cancel Payment' mod='mtborica'|escape:'javascript'}',
            text: '{l s='Do you confirm sending a Payment Cancellation request?' mod='mtborica'|escape:'javascript'}',
            showCancelButton: true,
            allowOutsideClick: false,
            confirmButtonColor: '#1E91CF',
            cancelButtonColor: '#E3503E',
            confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
            cancelButtonText: '{l s='No' mod='mtborica'|escape:'javascript'}',
        }).then((result) => {
            if (result.value !== undefined && result.value) {
                // Disable buttons and show loading state
                var $cancelBtn = $('#borica_btn_cancell_payment');
                var cancelBtnOriginalHtml = $cancelBtn.html();

                $cancelBtn.prop('disabled', true).css('opacity', '0.6').html('<i class="material-icons" style="vertical-align: middle; animation: spin 1s linear infinite;">autorenew</i> {l s='Processing...' mod='mtborica'|escape:'javascript'}');

                // Build data object with all possible parameters
                // Controller will use only what it needs based on action
                let data = {
                    action_type: 'cancelPayment',
                    ajax: 1,
                    token: '{$token|escape:'javascript':'UTF-8'}',
                    BORICA_URL: '{$borica_url|escape:'javascript':'UTF-8'}',
                    TERMINAL: '{$borica_terminal|escape:'javascript':'UTF-8'}',
                    TRTYPE: '{$borica_cancel_payment_trtype|escape:'javascript':'UTF-8'}',
                    AMOUNT: '{$borica_payment_total|escape:'javascript':'UTF-8'}',
                    CURRENT_AMOUNT: cancelAmount || null,
                    CURRENCY: '{$borica_currency|escape:'javascript':'UTF-8'}',
                    ORDER: '{$borica_order|escape:'javascript':'UTF-8'}',
                    DESC: '{l s='Order of goods from' mod='mtborica'|escape:'javascript'} ' + '{$base_url|escape:'javascript':'UTF-8'}',
                    MERCHANT: '{$borica_merchant|escape:'javascript':'UTF-8'}',
                    MERCH_NAME: '{$borica_mname|escape:'javascript':'UTF-8'}',
                    MERCH_URL: '{$base_url|escape:'javascript':'UTF-8'}',
                    EMAIL: '{$borica_email|escape:'javascript':'UTF-8'}',
                    COUNTRY: '{$borica_country|escape:'javascript':'UTF-8'}',
                    MERCH_GMT: '{$payment_data.merch_gmt|escape:'javascript':'UTF-8'}',
                    LANG: '{$borica_lang|escape:'javascript':'UTF-8'}',
                    ADDENDUM: '{$borica_addendum|escape:'javascript':'UTF-8'}',
                    AD_CUST_BOR_ORDER_ID: '{$borica_order_internal|escape:'javascript':'UTF-8'}',
                    RRN: '{$payment_data.rrn|escape:'javascript':'UTF-8'}',
                    INT_REF: '{$payment_data.int_ref|escape:'javascript':'UTF-8'}',
                    TIMESTAMP: '{$borica_timestamp|escape:'javascript':'UTF-8'}',
                    NONCE: '{$payment_data.nonce|escape:'javascript':'UTF-8'}',
                };

                $.ajax({
                    url: '{$admin_url|escape:'javascript':'UTF-8'}',
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function(response) {
                        // Re-enable buttons
                        $cancelBtn.prop('disabled', false).css('opacity', '1').html(
                            cancelBtnOriginalHtml);

                        if (response.resultChange) {
                            Swal.fire({
                                title: response.resultChangeTitle,
                                text: response.resultChangeText,
                                icon: 'success',
                                confirmButtonColor: '#1E91CF',
                                confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
                                allowOutsideClick: false
                            }).then((result) => {
                                const boricaAllowedTag =
                                    /<span[^>]*style="[^"]*"[^>]*>(.*?)<\/span>/i;
                                const boricaResponseText = response
                                    .requestCancelTxt
                                    .match(boricaAllowedTag);
                                if (boricaResponseText !== null) {
                                    $('#boricaRequestCancel').html(
                                        response
                                        .requestCancelTxt);
                                } else {
                                    $('#boricaRequestCancel').text(
                                        response
                                        .requestCancelTxt);
                                }
                                $('#borica_btn_cancell_payment').prop('disabled',
                                    true);
                            });
                        } else {
                            Swal.fire({
                                title: response.resultChangeTitle,
                                text: response.resultChangeText,
                                icon: 'error',
                                confirmButtonColor: '#1E91CF',
                                confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
                                allowOutsideClick: false
                            });
                        }
                    },
                    error: function() {
                        // Re-enable buttons
                        $cancelBtn.prop('disabled', false).css('opacity', '1').html(
                            cancelBtnOriginalHtml);

                        Swal.fire({
                            title: '{l s='Error' mod='mtborica'|escape:'javascript'}',
                            text: '{l s='An error occurred while processing the request.' mod='mtborica'|escape:'javascript'}',
                            icon: 'error',
                            confirmButtonColor: '#1E91CF',
                            confirmButtonText: '{l s='Yes' mod='mtborica'|escape:'javascript'}',
                            allowOutsideClick: false
                        });
                    },
                    complete: function() {
                        $('#current_amount').val('{$borica_payment_total|escape:'javascript':'UTF-8'}');
                    }
                });
            } else {
                return false
            }
        });
    }
    });
</script>