{* Product recurring plan field template *}
<div class="row">
    <div class="col-md-12">
        <h3>{l s='Payment by Credit/Debit Card' mod='mtborica'}</h3>
    </div>
    <div class="col-md-12">
        <label class="form-control-label">
            {l s='Recurring payments' mod='mtborica'}
            <span class="help-box" data-toggle="popover"
                data-content="{l s='Select one or more recurring payment plans for this product. These plans will be available as options for customers on the product page. Customers will be able to purchase this product with recurring payments using the selected plans.' mod='mtborica'}"
                data-original-title="" title=""></span>
        </label>
        <select name="mtborica_recurring_plan_ids[]" id="mtborica_recurring_plan_ids" class="form-control"
            multiple="multiple" aria-label="mtborica_recurring_plan_ids input">
            {if isset($recurring_plans) && !empty($recurring_plans)}
                {foreach from=$recurring_plans item=plan}
                    <option value="{$plan.id|intval}"
                        {if isset($selected_plan_ids) && is_array($selected_plan_ids) && in_array($plan.id, $selected_plan_ids)}selected="selected"
                        {/if}>
                        {$plan.name|escape:'html':'UTF-8'}
                    </option>
                {/foreach}
            {/if}
        </select>
        <p class="help-block">
            {l s='Select one or more recurring payment plans. These plans will be available as options for customers on the product page. Customers will not be able to mix recurring and standard products in the cart.' mod='mtborica'}
        </p>
    </div>
</div>

{* Select2 styles *}
<style>
    /* Select2 container styles */
    #mtborica_recurring_plan_ids+.select2-container {
        width: 100% !important;
    }

    /* Select2 selection area - better spacing for multiple selections */
    #mtborica_recurring_plan_ids+.select2-container .select2-selection--multiple {
        min-height: 38px;
        padding: 2px 5px;
        border: 1px solid #ced4da;
        border-radius: 0.25rem;
        background-color: #fff;
    }

    /* Individual selected items (tags) */
    #mtborica_recurring_plan_ids+.select2-container .select2-selection--multiple .select2-selection__choice {
        background-color: #007bff;
        border: 1px solid #007bff;
        color: #fff;
        padding: 3px 8px;
        margin: 3px 5px 3px 0;
        border-radius: 3px;
        font-size: 13px;
        line-height: 1.5;
        display: inline-block;
        max-width: 100%;
    }

    /* Remove button (X) on selected items */
    #mtborica_recurring_plan_ids+.select2-container .select2-selection--multiple .select2-selection__choice__remove {
        color: #fff;
        cursor: pointer;
        display: inline-block;
        font-weight: bold;
        margin-right: 5px;
        padding: 0;
        border: none;
        background: transparent;
    }

    #mtborica_recurring_plan_ids+.select2-container .select2-selection--multiple .select2-selection__choice__remove:hover {
        color: #fff;
        opacity: 0.8;
    }

    /* Search input inside Select2 */
    #mtborica_recurring_plan_ids+.select2-container .select2-search--inline .select2-search__field {
        padding: 5px;
        margin: 0;
        min-height: 30px;
        border: none;
        outline: none;
        box-shadow: none;
    }

    /* Dropdown menu */
    #mtborica_recurring_plan_ids+.select2-container .select2-dropdown {
        border: 1px solid #ced4da;
        border-radius: 0.25rem;
    }

    /* Options in dropdown */
    #mtborica_recurring_plan_ids+.select2-container .select2-results__option {
        padding: 8px 12px;
    }

    #mtborica_recurring_plan_ids+.select2-container .select2-results__option--highlighted {
        background-color: #007bff;
        color: #fff;
    }

    /* Focus state */
    #mtborica_recurring_plan_ids+.select2-container.select2-container--focus .select2-selection--multiple {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }
</style>

{* Select2 initialization *}
<script type="text/javascript">
    $(document).ready(function() {
        // Check if Select2 is available (PrestaShop 1.7+ includes it)
        if (typeof $.fn.select2 !== 'undefined') {
            $('#mtborica_recurring_plan_ids').select2({
                placeholder: '{l s='Choose one or more Recurring Payment Plans' mod='mtborica'|escape:'javascript':'UTF-8'}',
                allowClear: true,
                width: '100%',
                closeOnSelect: false,
                language: {
                    noResults: function() {
                        return '{l s='No plans found' mod='mtborica'|escape:'javascript':'UTF-8'}';
                    }
                }
            });
        } else {
            // Fallback: Load Select2 from CDN if not available
            if (!$('link[href*="select2"]').length) {
                $('head').append(
                    '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">'
                );
            }
            if (!$('script[src*="select2"]').length) {
                $.getScript('https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js',
                    function() {
                        $('#mtborica_recurring_plan_ids').select2({
                            placeholder: '{l s='Choose one or more Recurring Payment Plans' mod='mtborica'|escape:'javascript':'UTF-8'}',
                            allowClear: true,
                            width: '100%',
                            closeOnSelect: false,
                            language: {
                                noResults: function() {
                                    return '{l s='No plans found' mod='mtborica'|escape:'javascript':'UTF-8'}';
                                }
                            }
                        });
                    });
            }
        }
    });
</script>