{*
 * Order detail recurring plan cancel button template
 * Displays button to cancel recurring payment plan on order detail page
 * Form is submitted directly to BORICA
 *}

<!-- SweetAlert2 CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div class="mtborica-recurring-cancel-section">
    <div class="alert alert-info">
        <h4>{l s='Recurring Payment Plan' mod='mtborica'}</h4>
        <p>
            {l s='This order uses recurring payment plan:' mod='mtborica'}
            <strong>{$recurring_plan_name|escape:'html':'UTF-8'}</strong>
        </p>
        <p class="mb-0">
            <button type="button" id="mtborica-cancel-recurring-btn" class="btn btn-danger">
                {l s='Close recurring plan' mod='mtborica'}
            </button>
        </p>
    </div>
</div>

{* Hidden form for BORICA submission *}
<form id="mtborica-cancel-recurring-form" method="POST" action="{$borica_url|escape:'html':'UTF-8'}"
    style="display: none;">
    {foreach from=$borica_form_data key=field_name item=field_value}
        <input type="hidden" name="{$field_name|escape:'html':'UTF-8'}" value="{$field_value|escape:'htmlall':'UTF-8'}">
    {/foreach}
</form>

<script type="text/javascript">
    (function() {
        var cancelBtn = document.getElementById('mtborica-cancel-recurring-btn');
        var cancelForm = document.getElementById('mtborica-cancel-recurring-form');

        if (!cancelBtn || !cancelForm) {
            return;
        }

        cancelBtn.addEventListener('click', function(e) {
            e.preventDefault();

            Swal.fire({
                title: '{l s='Close Recurring Plan?' mod='mtborica' js=1}',
                text: '{l s='Are you sure you want to close this recurring payment plan? This action cannot be undone.' mod='mtborica' js=1}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: '{l s='Yes, close it' mod='mtborica' js=1}',
                cancelButtonText: '{l s='Cancel' mod='mtborica' js=1}',
                reverseButtons: true
            }).then(function(result) {
                if (result.value !== undefined && result.value) {
                    // Submit form to BORICA
                    cancelForm.submit();
                }
            });
        });
    })();
</script>